within ModelicaLib.Driveshaft_test;
model Driveshaft

  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a
    annotation (Placement(transformation(extent={{-86,36},{-66,56}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_b
    annotation (Placement(transformation(extent={{60,36},{80,56}})));

  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=0.01)
    annotation (Placement(transformation(extent={{-38,36},{-18,56}})));
  Modelica.Mechanics.Rotational.Components.Damper damper(d=0.0001)
    annotation (Placement(transformation(extent={{32,10},{52,30}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{38,-18},{58,2}})));
equation
  connect(inertia.flange_a, flange_a) annotation (Line(
      points={{-38,46},{-76,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper.flange_b, fixed.flange) annotation (Line(
      points={{52,20},{52,-8},{48,-8}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(inertia.flange_b, flange_b) annotation (Line(
      points={{-18,46},{70,46}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper.flange_a, inertia.flange_b) annotation (Line(
      points={{32,20},{8,20},{8,46},{-18,46}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")),
    Diagram(graphics),
    Icon(graphics={Text(
          extent={{-70,86},{82,-66}},
          lineColor={0,0,255},
          textString="Centrifugal Clutch")}));
end Driveshaft;
